/*
 * Decompiled with CFR 0.152.
 */
package TET;

import TET.JournalWriter;
import TET.SyncMessage;
import TET.SystemEntry;
import TET.TetError;
import TET.TetException;
import TET.TetThread;
import TET.ThreadData;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;

public final class TestSession {
    static final String sccsid = "@(#)TestSession.java\t1.1 (99/09/03) TETware release 3.7";
    public static final int TET_PASS = 0;
    public static final int TET_FAIL = 1;
    public static final int TET_UNRESOLVED = 2;
    public static final int TET_NOTINUSE = 3;
    public static final int TET_UNSUPPORTED = 4;
    public static final int TET_UNTESTED = 5;
    public static final int TET_UNINITIATED = 6;
    public static final int TET_NORESULT = 7;
    public static final int TET_SV_YES = 1;
    public static final int TET_SV_NO = 2;
    public static final int TET_ER_OK = 0;
    public static final int TET_ER_ERR = 1;
    public static final int TET_ER_MAGIC = 2;
    public static final int TET_ER_LOGON = 3;
    public static final int TET_ER_RCVERR = 4;
    public static final int TET_ER_REQ = 5;
    public static final int TET_ER_TIMEDOUT = 6;
    public static final int TET_ER_DUPS = 7;
    public static final int TET_ER_SYNCERR = 8;
    public static final int TET_ER_INVAL = 9;
    public static final int TET_ER_TRACE = 10;
    public static final int TET_ER_WAIT = 11;
    public static final int TET_ER_XRID = 12;
    public static final int TET_ER_SNID = 13;
    public static final int TET_ER_SYSID = 14;
    public static final int TET_ER_INPROGRESS = 15;
    public static final int TET_ER_DONE = 16;
    public static final int TET_ER_CONTEXT = 17;
    public static final int TET_ER_PERM = 18;
    public static final int TET_ER_FORK = 19;
    public static final int TET_ER_NOENT = 20;
    public static final int TET_ER_PID = 21;
    public static final int TET_ER_SIGNUM = 22;
    public static final int TET_ER_FID = 23;
    public static final int TET_ER_INTERN = 24;
    public static final int TET_ER_ABORT = 25;
    public static final int TET_ER_2BIG = 26;
    private static long THREADTIMEOUT = 5000L;
    private static int nInstances = 0;
    private String[] errList = this.getErrList();
    private String tet_root = this.getenv("TET_ROOT");
    private Hashtable threadDataTable = new Hashtable();
    private long nextBlock = 0L;
    private String pname;
    private ThreadGroup tgroup;

    private TestSession(String string) {
        this.pname = string;
        this.tgroup = null;
    }

    static synchronized TestSession createTestSession(String string, String string2) {
        if (nInstances++ > 0) {
            throw new TetError("Illegal attempt to create more than one instance of class TET.TestSession");
        }
        System.loadLibrary(string2);
        return new TestSession(string);
    }

    private native String getenv(String var1);

    public native int tet_thistest();

    public String tet_pname() {
        return this.pname;
    }

    public String[] tet_errlist() {
        return this.errList;
    }

    private native String[] getErrList();

    public synchronized native void tet_setcontext();

    public void tet_setblock() {
        this.newBlock(this.getThreadData());
    }

    public int tet_getblock() {
        return (int)this.getThreadData().block;
    }

    public synchronized native void tet_infoline(String var1);

    public synchronized native void tet_minfoline(String[] var1) throws TetException;

    public synchronized native void tet_result(int var1);

    public synchronized native void tet_delete(int var1, String var2);

    public synchronized native String tet_reason(int var1);

    public synchronized native String tet_getvar(String var1);

    public long tet_spawn(String string, String[] stringArray, String[] stringArray2) throws TetException {
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        return this.spawn(string, stringArray, stringArray2);
    }

    public long tet_jspawn(String string, String[] stringArray, String[] stringArray2) throws TetException {
        if (this.tet_root == null) {
            String string2 = "Unable to determine value of TET_ROOT in environment";
            this.tet_error(0, string2);
            throw new TetException(1, string2, 0L, null);
        }
        int n = stringArray == null ? 0 : stringArray.length;
        String[] stringArray3 = new String[3 + n];
        stringArray3[0] = this.tet_root + File.separator + "bin" + File.separator + "jet-spawn";
        stringArray3[1] = "TET_JAVA_SPAWN_MAGIC";
        stringArray3[2] = string;
        if (n > 0) {
            System.arraycopy(stringArray, 0, stringArray3, 3, n);
        }
        return this.tet_spawn(stringArray3[0], stringArray3, stringArray2);
    }

    private synchronized native long spawn(String var1, String[] var2, String[] var3) throws TetException;

    public synchronized native int tet_wait(long var1) throws TetException;

    public synchronized native void tet_kill(long var1, int var3) throws TetException;

    public synchronized native void tet_remsync(long var1, int[] var3, int var4, int var5, SyncMessage var6) throws TetException;

    public synchronized native int[] tet_remgetlist();

    public synchronized native int tet_remgetsys();

    public SystemEntry tet_getsysbyid(int n) throws TetException {
        return new SystemEntry(n, this.getsysname(n));
    }

    private synchronized native String getsysname(int var1) throws TetException;

    public Date tet_remtime(int n) throws TetException {
        return new Date(this.remtime(n) * 1000L);
    }

    private synchronized native long remtime(int var1) throws TetException;

    public synchronized native void tet_exit(int var1);

    public synchronized native void tet_logoff();

    void tet_error(int n, String string) {
        this.tet_merror(n, new String[]{string});
    }

    synchronized native void tet_merror(int var1, String[] var2);

    void reportError(Throwable throwable, int n, String string) {
        if (throwable == null) {
            this.tet_error(0, string);
        } else {
            if (throwable instanceof Error) {
                throw (Error)throwable.fillInStackTrace();
            }
            PrintWriter printWriter = new PrintWriter(new JournalWriter(this, string));
            throwable.printStackTrace(printWriter);
            printWriter.flush();
        }
        if (this.tet_thistest() != 0) {
            this.tet_result(n);
        }
    }

    void initThreads(String string, boolean bl) {
        this.cleanThreads();
        this.tgroup = new ThreadGroup("TET:" + this.tet_pname() + ":" + string);
        this.nextBlock = bl ? 0L : this.getThreadData().block - 1L;
        this.threadDataTable.clear();
        this.getThreadData();
    }

    void cleanThreads() {
        if (this.tgroup == null) {
            return;
        }
        Thread[] threadArray = new Thread[this.tgroup.activeCount()];
        int n = this.tgroup.enumerate(threadArray, false);
        int n2 = 0;
        while (n2 < n) {
            if (threadArray[n2] != Thread.currentThread()) {
                long l = threadArray[n2] instanceof TetThread ? ((TetThread)threadArray[n2]).getWaitTime() : 0L;
                try {
                    threadArray[n2].join(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (threadArray[n2].isAlive()) {
                    threadArray[n2].interrupt();
                    try {
                        threadArray[n2].join(THREADTIMEOUT);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (threadArray[n2].isAlive()) {
                        throw new TetError("Wait failed for one or more threads");
                    }
                }
            }
            ++n2;
        }
        this.tgroup = null;
    }

    ThreadGroup threadgroup() {
        return this.tgroup;
    }

    ThreadData getThreadData() {
        Thread thread = Thread.currentThread();
        ThreadData threadData = (ThreadData)this.threadDataTable.get(thread);
        if (threadData == null) {
            threadData = new ThreadData();
            this.newBlock(threadData);
            this.threadDataTable.put(thread, threadData);
        }
        return threadData;
    }

    private synchronized void newBlock(ThreadData threadData) {
        threadData.block = ++this.nextBlock;
        threadData.sequence = 1L;
    }
}

